/*
 * Decompiled with CFR 0.152.
 */
package net.satisfyu.meadow.block;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfyu.meadow.registry.ObjectRegistry;

public class WoodenFlowerPotBlock
extends Block {
    private static final Map<Block, Block> WOODEN_CONTENT_TO_POTTED = Maps.newHashMap();
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    private final Block content;

    public WoodenFlowerPotBlock(Block content, BlockBehaviour.Properties settings) {
        super(settings);
        this.content = content;
        WOODEN_CONTENT_TO_POTTED.put(content, this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean bl2;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        BlockState blockState = (item instanceof BlockItem ? WOODEN_CONTENT_TO_POTTED.getOrDefault(((BlockItem)item).m_40614_(), Blocks.f_50016_) : Blocks.f_50016_).m_49966_();
        boolean bl = blockState.m_60713_(Blocks.f_50016_);
        if (bl != (bl2 = this.isEmpty())) {
            if (bl2) {
                world.m_7731_(pos, blockState, 3);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            } else {
                ItemStack itemStack2 = new ItemStack((ItemLike)this.content);
                if (itemStack.m_41619_()) {
                    player.m_21008_(hand, itemStack2);
                } else if (!player.m_36356_(itemStack2)) {
                    player.m_36176_(itemStack2, false);
                }
                world.m_7731_(pos, ((Block)ObjectRegistry.WOODEN_FLOWER_POT.get()).m_49966_(), 3);
            }
            world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        if (this.isEmpty()) {
            return super.m_7397_(world, pos, state);
        }
        return new ItemStack((ItemLike)this.content);
    }

    private boolean isEmpty() {
        return this.content == Blocks.f_50016_;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"block.meadow.canbeplaced.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }

    public ItemLike getContent() {
        return this.content;
    }
}

